import { getAgencies } from "@/server/api.agencies";
import { TransformedAgencies, TransformedAgency } from "@/types/transformers";
import { AppValidationStatusOption } from "@/zod/feeds.schema";

type INTERNAL__GroupedAgenciesRecord = Record<Exclude<AppValidationStatusOption, "NO BUILD" | "TIMED_OUT" | "ABORTED" | "PENDING_REDRIVE">, TransformedAgencies> & {
  ALL: Map<string, TransformedAgency>
}

export async function revalidateBuildStatusCheckMap() {
  const agencies = await getAgencies()
  if (!agencies) {
    return undefined
  }

  return agencies.reduce<INTERNAL__GroupedAgenciesRecord>((total, current) => {
    total.ALL.set(current.gtfsId, current)

    if (current.status.option === "NO BUILD"
      || current.status.option === "TIMED_OUT"
      || current.status.option === "ABORTED"
      || current.status.option === "PENDING_REDRIVE"
    ) {
      return total
    }

    const potentialGroup = total[current.status.option]
    if (!potentialGroup) {
      return total
    }

    potentialGroup.push(current)
    return total;
  }, {
    ALL: new Map(),
    RUNNING: [],
    SUCCEEDED: [],
    FAILED: [],
  })
}

